/*
 * Copyright (c) 2005 by NOAATS Technology, Inc.
 * 
 * 5F, Dong Sung Bldg.17-8, Yeouido-Dong Yeongdeungpo-Gu, Seoul 150-874, Korea
 * All rights reserved.
 */
package net.kldp.logviewer.db.common.pool;

import java.sql.DriverManager;
import java.sql.SQLException;

import net.kldp.logviewer.common.config.CommonConfig;
import net.kldp.logviewer.common.log.LogViews;

import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;


/**
 * <PRE>
 * 
 * Title : ؼ Ǯ Ѵ.
 * 				ó ѹ ǾѴ.
 * Comment :
 * 
 * History : 
 * 
 * </PRE>
 * 
 * @version 0.1, 2005. 9. 15.
 * @author henry
 */
public class ConnectionInitialize {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LogViews.getLogger(ConnectionInitialize.class);

	/**
	 * ü ʱȭ Ѵ.
	 */
	public void init(String poolName) throws Exception {
		String driverClassName 		= CommonConfig.getWentProp(poolName + ".DriverName");
		String url 					= CommonConfig.getWentProp(poolName + ".DataSource");
		String databaseName			= CommonConfig.getWentProp(poolName + ".DataBaseName");
		String username 			= CommonConfig.getWentProp(poolName + ".User");
		String password 			= CommonConfig.getWentProp(poolName + ".Pass");
		boolean defaultAutoCommit 	= CommonConfig.getWentPropBool(poolName + ".AutoCommit");
		boolean defaultReadOnly 	= CommonConfig.getWentPropBool(poolName + ".DefaultReadOnly");
		int maxActive 				= CommonConfig.getWentPropInt(poolName + ".MaxActive");
		int maxIdle 				= CommonConfig.getWentPropInt(poolName + ".MaxIdle");
		long maxWait 				= CommonConfig.getWentPropInt(poolName + ".MaxWait");

		try {
			setupDriver(
				poolName,
				driverClassName,
				url,
				databaseName,
				username,
				password,
				defaultAutoCommit,
				defaultReadOnly,
				maxActive,
				maxIdle,
				maxWait
			);

			logger.debug("Creation the Connection Pooling Object");
		} catch (Exception e) {
			logger.debug("Fail the Connection initialize!!!");
			e.printStackTrace();
			
			throw e;
		}
	}

	/**
	 * Driver εѴ.
	 * 
	 * @param driverClassName
	 * @param url
	 * @param databaseName
	 * @param username
	 * @param password
	 * @param defaultAutoCommit
	 * @param defaultReadOnly
	 * @param maxActive
	 * @param maxIdle
	 * @param maxWait
	 * @throws Exception
	 */
	public void setupDriver(
			String poolName			, String driverClassName, 
			String url				, String databaseName	,
			String username			, String password	   	, 
			boolean defaultAutoCommit,	boolean defaultReadOnly	, 
			int maxActive			, int maxIdle			, 
			long maxWait)	throws ClassNotFoundException, SQLException {

		try {
			Class.forName(driverClassName);
		} catch (ClassNotFoundException cnfe) {
			logger.error(driverClassName + " is not found", cnfe);
			
			throw cnfe;
		}

		// Ŀؼ Ǯ  commons-collections genericOjbectPool մϴ.
		GenericObjectPool connectionPool = new GenericObjectPool(null);
		
		connectionPool.setMaxActive(maxActive);
		
		connectionPool.setMaxIdle(maxIdle);
		
		connectionPool.setMaxWait(maxWait);

		// Ȱȭ Ŀؼ   Ŀؼ ȿ θ ˻ؼ ȿ  Ŀؼ Ǯ Ѵ.
		connectionPool.setTestWhileIdle(true);
		
		// Ŀؼ Ǯ Ŀؼ ü   Ŀؼ Ͻ Ŀؼ  Ѵ.
		connectionPool.setWhenExhaustedAction((byte)2);
		
		//   Ŀؼ ϴ   ֱ⸦ Ѵ
		connectionPool.setTimeBetweenEvictionRunsMillis(600000); 

		// Ǯ Ŀؼ ϴµ ϴ DriverManagerConnectionFactory մϴ.
		ConnectionFactory connectionFactory = 
				new DriverManagerConnectionFactory(url, username, password);

		// ConnectionFactory  Ŭ PoolableConnectionFactory Ѵ
		PoolableConnectionFactory poolableConnectionFactory = 
			new PoolableConnectionFactory(connectionFactory, connectionPool, null, null, defaultReadOnly, defaultAutoCommit);

		try {
			//  PoolingDriver ڽ εѴ
			Class.forName("org.apache.commons.dbcp.PoolingDriver");
		} catch(ClassNotFoundException cnfe) {
			logger.error("org.apache.commons.dbcp.PoolingDriver is not found", cnfe);
			
			throw cnfe;
		}
			
		try {
			PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
			
			//Ǯ ̸ Ѵ.
			driver.registerPool(poolName, connectionPool);
		} catch(SQLException sqle) {
			logger.error(poolName + " Connection Pool ϴ ߿  ߻߽ϴ.", sqle);
			
			throw sqle;
		}
	}
}
